package ags.game;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
/*
 * Games.java
 *
 * Created on May 17, 2006, 6:42 PM
 *
 * Utility for getting information about games repository
 * @author blurry
 */
/**
 * Utility to read list of games from configuration
 */
public class Games {
    
    /** Creates a new instance of Games */
    public Games() {
    }
    
    /**
     * XML Node for a game
     */
    private static final String GAME_NODE = "game";
    /**
     * XML Node for a file
     */
    private static final String FILE_NODE = "file";
    /**
     * Attribute for game name
     */
    private static final String NAME_ATTR = "name";
    /**
     * Attribute for game file path
     */
    private static final String FILE_ATTR = "file";
    /**
     * Attribute for game file type
     */
    private static final String TYPE_ATTR = "type";
    /**
     * Attribute for game starting memory address
     */
    private static final String START_ATTR = "start";
    
    /**
     * Read list of games from the configuration file
     * @return list of game beans
     */
    public static List<Game> readFromFile() {
        try {
            List<Game> out = new ArrayList<Game>();
            Document d = parseConfiguration();
            NodeList games = d.getDocumentElement().getElementsByTagName(GAME_NODE);
            for (int i=0; i < games.getLength(); i++) {
                Element game = (Element) games.item(i);
                String name = game.getAttribute(NAME_ATTR);
                String file = game.getAttribute(FILE_ATTR);
                String type = game.getAttribute(TYPE_ATTR);
                String start = game.getAttribute(START_ATTR);
                Game g = new Game();
                g.setFile(file);
                g.setName(name);
                if (type != null && !"".equals(type))
                    g.setType(Integer.decode("0x"+type));
                if (start != null && !"".equals(start))
                    g.setStart(Integer.decode("0x"+start));
                out.add(g);
            }
            return out;
        } catch (ParserConfigurationException ex) {
            ex.printStackTrace();
        } catch (IOException ex) {
            ex.printStackTrace();
        } catch (SAXException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    /**
     * Parse a config file to a usable DOM document
     * @throws org.xml.sax.SAXException if the xml is problematic
     * @throws java.io.IOException if the file cannot be found or read properly
     * @throws javax.xml.parsers.ParserConfigurationException if the xml is problematic
     * @return Parsed dom tree of games
     */
    private static Document parseConfiguration() throws SAXException, IOException, ParserConfigurationException {
        InputStream confStream = Games.class.getResourceAsStream("/data/games.xml");
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document d = builder.parse(confStream);
        return d;
    }
    
}
